IF NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.TABLES	WHERE TABLE_NAME=N'GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL')
BEGIN
	SET ANSI_NULLS ON
	SET QUOTED_IDENTIFIER ON
	--DROP TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL]
	CREATE TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL](
		[CD_EMP] [int] NOT NULL,
		[CD_CONFIG] [int] NOT NULL, 
		[CD_FILIAL] [int] NOT NULL, 
		[CD_USU] [int] NULL,
		[DT_CAD] [datetime] NULL,
		[DT_ULT_ALT] [datetime] NULL,
	 CONSTRAINT [PK_GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL] PRIMARY KEY CLUSTERED 
	(	
		[CD_FILIAL] ASC,
		[CD_CONFIG] ASC,
		[CD_EMP] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
	) ON [PRIMARY] 
	ALTER TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL] ADD  CONSTRAINT [DF_GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL_CD_USU]  DEFAULT ((0)) FOR [CD_USU]
	
	ALTER TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL]  WITH CHECK ADD  
		CONSTRAINT [FK_GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL_PRC_FILIAL] FOREIGN KEY([CD_EMP],[CD_FILIAL])
			REFERENCES [dbo].[PRC_FILIAL] ([CD_EMP],[CD_FILIAL])
		ALTER TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL] CHECK CONSTRAINT [FK_GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL_PRC_FILIAL]

	ALTER TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL]  WITH CHECK ADD  
			CONSTRAINT [FK_GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL_GLB_CONFIG_PRECO_RESSUP] FOREIGN KEY([CD_CONFIG])
			REFERENCES [dbo].[GLB_CONFIG_PRECO_RESSUP] ([CD_CONFIG])
		ALTER TABLE [dbo].[GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL] CHECK CONSTRAINT [FK_GLB_CONFIG_PRECO_RESSUP_PRC_FILIAL_GLB_CONFIG_PRECO_RESSUP]
END


